/*
 * Decompiled with CFR 0.152.
 */
package external;

import java.util.HashMap;
import java.util.Map;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public final class FunctionSupport {
    private static final String EXACT_PARAMETERS = "%s() takes exactly %d arguments (%d given)";
    private static final String AT_MOST_PARAMETERS = "%s() takes at most %d arguments (%d given)";
    private static final String AT_LEAST_PARAMETERS = "%s() takes at least %d arguments (%d given)";
    private static final String EXACT_KW_PARAMETERS = "%s() takes exactly %d non-keyword arguments (%d given)";
    private static final String AT_MOST_KW_PARAMETERS = "%s() takes at most %d non-keyword arguments (%d given)";
    private static final String AT_LEAST_KW_PARAMETERS = "%s() takes at least %d non-keyword arguments (%d given)";
    private static final String UNEXPECTED_KEYWORD = "%s() got an unexpected keyword argument '%s'";
    private static final String MULTIPLE_VALUES = "%s() got multiple values for keyword argument '%s'";
    private static final String DUPLICATE_ARGUMENT = "duplicate argument '%s' in function definition";
    private String name;
    private String[] formalParameters;
    private PyObject[] defaults;
    private String extraPositionalParameters;
    private String extraKeywordParameters;

    public FunctionSupport(String name, String[] parameters) {
        this(name, parameters, null, null, null);
    }

    public FunctionSupport(String name, String[] parameters, PyObject[] defaults) {
        this(name, parameters, defaults, null, null);
    }

    public FunctionSupport(String name, String[] parameters, PyObject[] defaults, String extraPositionalParameters, String extraKeywordParameters) {
        int nDefaults;
        int nParameters = parameters == null ? 0 : parameters.length;
        int n = nDefaults = defaults == null ? 0 : defaults.length;
        if (nDefaults > nParameters) {
            throw new IllegalArgumentException("more defaults were specified than parameters");
        }
        this.name = name;
        if (parameters == null) {
            this.formalParameters = new String[0];
        } else {
            this.formalParameters = new String[parameters.length];
            System.arraycopy(parameters, 0, this.formalParameters, 0, nParameters);
        }
        if (defaults == null) {
            this.defaults = new PyObject[0];
        } else {
            this.defaults = new PyObject[defaults.length];
            System.arraycopy(defaults, 0, this.defaults, 0, nDefaults);
        }
        this.extraPositionalParameters = extraPositionalParameters;
        this.extraKeywordParameters = extraKeywordParameters;
        if (this.findParameter(extraPositionalParameters) >= 0) {
            String message = String.format(DUPLICATE_ARGUMENT, extraPositionalParameters);
            throw new IllegalArgumentException(message);
        }
        if (this.findParameter(extraKeywordParameters) >= 0) {
            String message = String.format(DUPLICATE_ARGUMENT, extraKeywordParameters);
            throw new IllegalArgumentException(message);
        }
    }

    public Map<String, PyObject> args(PyObject[] args, String[] keywords) {
        int i;
        PyTuple extraParameters = null;
        PyDictionary extraKeywords = null;
        int nParams = this.formalParameters.length;
        int keywordOffset = args.length - keywords.length;
        int defaultsOffset = this.formalParameters.length - this.defaults.length;
        PyObject[] parameters = new PyObject[nParams];
        System.arraycopy(args, 0, parameters, 0, Math.min(keywordOffset, nParams));
        if (keywordOffset > nParams && this.extraPositionalParameters != null) {
            int nExtraParameters = keywordOffset - nParams;
            PyObject[] tmp = new PyObject[nExtraParameters];
            System.arraycopy(args, nParams, tmp, 0, nExtraParameters);
            extraParameters = new PyTuple(tmp);
        } else {
            if (keywordOffset > nParams) {
                String message = keywords.length == 0 ? (this.defaults.length == 0 ? EXACT_PARAMETERS : AT_MOST_PARAMETERS) : (this.defaults.length == 0 ? EXACT_KW_PARAMETERS : AT_MOST_KW_PARAMETERS);
                message = String.format(message, this.name, nParams, keywordOffset);
                throw Py.TypeError((String)message);
            }
            if (this.extraPositionalParameters != null) {
                extraParameters = new PyTuple();
            }
        }
        if (this.extraKeywordParameters != null) {
            extraKeywords = new PyDictionary();
        }
        for (i = 0; i < keywords.length; ++i) {
            int iSlot = this.findParameter(keywords[i]);
            if (iSlot < 0 && this.extraKeywordParameters != null) {
                extraKeywords.__setitem__((PyObject)new PyString(keywords[i]), args[i + keywordOffset]);
                continue;
            }
            if (iSlot < 0) {
                String message = String.format(UNEXPECTED_KEYWORD, this.name, keywords[i]);
                throw Py.TypeError((String)message);
            }
            if (parameters[iSlot] == null) {
                parameters[iSlot] = args[i + keywordOffset];
                continue;
            }
            String message = String.format(MULTIPLE_VALUES, this.name, keywords[i]);
            throw Py.TypeError((String)message);
        }
        for (i = 0; i < this.defaults.length; ++i) {
            if (parameters[i + defaultsOffset] != null) continue;
            parameters[i + defaultsOffset] = this.defaults[i];
        }
        for (i = 0; i < nParams; ++i) {
            if (parameters[i] != null) continue;
            String message = keywords.length == 0 ? (this.defaults.length == 0 ? EXACT_PARAMETERS : AT_LEAST_PARAMETERS) : (this.defaults.length == 0 ? EXACT_KW_PARAMETERS : AT_LEAST_KW_PARAMETERS);
            message = String.format(message, this.name, defaultsOffset, keywordOffset);
            throw Py.TypeError((String)message);
        }
        HashMap<String, PyObject> result = new HashMap<String, PyObject>();
        for (i = 0; i < nParams; ++i) {
            result.put(this.formalParameters[i], parameters[i]);
        }
        if (this.extraPositionalParameters != null) {
            result.put(this.extraPositionalParameters, (PyObject)extraParameters);
        }
        if (this.extraKeywordParameters != null) {
            result.put(this.extraKeywordParameters, (PyObject)extraKeywords);
        }
        return result;
    }

    private int findParameter(String keyword) {
        for (int i = 0; i < this.formalParameters.length; ++i) {
            if (keyword == null || !keyword.equals(this.formalParameters[i])) continue;
            return i;
        }
        return -1;
    }
}

